<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin\Role;
use App\Models\Admin\Website;
use App\Models\Admin\Category;
use App\Models\Admin\SubCategory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class SubCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $categorys = Category::orderBy('id', 'ASC')->get();
        $sub_categorys = SubCategory::orderBy('id', 'ASC')->get();
        $website = Website::latest()->first();
        return view('backend.pages.system-setting.sub-category', compact('categorys', 'sub_categorys', 'website'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:categories|max:100',
        ],[
            'name.required'=> 'Please give a unique category name.'
        ]);

        $category = new SubCategory();
        $category->category_id = $request->input('category_id');
        $category->name = Str::ucfirst($request->input('name'));
        $category->slug = Str::slug($request->input('name'));
        $category->minimum_cost = $request->input('minimum_cost');
        $category->save();

        return redirect()->back()->with('message','Category added Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|max:100',
        ],[
            'name.required'=> 'Please give a unique category name.'
        ]);

        $category = SubCategory::find($id);
        $category->name = Str::ucfirst($request->input('name'));
        $category->minimum_cost = $request->input('minimum_cost');
        $category->save();

        return redirect()->back()->with('message','Category Update Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
